/*
Dotty V1.0 - The Dots Game (Les Petits Carreaux)
Copyright (C) 1998 Franois Pessaux (francois.pessaux@inria.fr)


This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#define dotAppId 'DoTg'
/* Name of the data base containing saved game */
#define dotsStateName "DotsCurrent"

#define BLOCK_SIZE_X 16
#define BLOCK_SIZE_Y 16

#define POINT_TOLERANCE 4

#define TITLE_HEIGHT 17
#define ARROW_WIDTH 7
#define ARROW_HEIGHT 7
#define LEADING_SPACE 3

typedef unsigned char boolean ;

struct vertex {
  unsigned char group ;
} ;

struct edge {
  /* Indexes in the global vertices array */
    unsigned char drawn ;
    unsigned char v1 ;
    unsigned char v2 ;
} ;

#define OWNER_NONE 0
#define OWNER_HUMAN 1
#define OWNER_PILOT 2

struct cell {
    /* Indexes in the global vertices array */
    boolean owner ;
    unsigned char left ;
    unsigned char top ;
    unsigned char right ;
    unsigned char bottom ;
} ;

/*
Vertices :
0 -- 1 -- 2  -- 3
|    |    |     |
4 -- 5 -- 6  -- 7
|    |    |     |
8 -- 9 -- 10 -- 11

Edges :
x -0- x -1- x -2- x
|     |     |     |
9     10    11    12
|     |     |     |
x -3- x -4- x -5- x
|     |     |     |
13    14    15    16
|     |     |     |
x -6- x -7- x -8- x

Cells :
x -- x -- x -- x
|    |    |    |
|  0 | 1  | 2  |
|    |    |    |
x -- x -- x -- x
|    |    |    |
| 3  | 4  | 6  |
|    |    |    |
x -- x -- x -- x
*/


/*
#Vertices = (width + 1) * (height + 1)
#edges = width * (height + 1) + height * (width + 1)
#cells = width * height
*/


/* Event type for telling computer to play */
#define dotComputerMustPlay firstUserEvent

/* Preference structure */
struct dotprefs {
  unsigned char pref_game_width  ;
  unsigned char pref_game_height  ;
  unsigned char pref_pilot_plays_first  ;
};
