/*
Dotty V1.0 - The Dots Game (Les Petits Carreaux)
Copyright (C) 1998 Franois Pessaux (francois.pessaux@inria.fr)


This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>

#include "bool.h"
#include "dots.h"
#include "protos.h"


extern struct vertex *vertices ;



void edge_get_groups (struct edge *edge, unsigned char *grp0,
		      unsigned char *grp1)
{
 unsigned char g1, g2 ;

 g1 = vertices[edge->v1].group ;
 g2 = vertices[edge->v2].group ;
 if (g1 > g2) {
   *grp0 = g1 ;
   *grp1 = g2 ;
 }
 else {
   *grp0 = g2 ;
   *grp1 = g1 ;
 }
}

