/*
Dotty V1.0 - The Dots Game (Les Petits Carreaux)
Copyright (C) 1998 Franois Pessaux (francois.pessaux@inria.fr)


This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>

#include "pilrc.h"
#include "bool.h"
#include "dots.h"
#include "protos.h"

extern unsigned char game_width ;
extern unsigned char game_height ;
extern struct vertex *vertices ;
extern struct edge *edges ;
extern struct cell *cells ;
extern unsigned char pilot_plays_first ;
extern unsigned char remaining_cells ;


Boolean OptionEventHandler (EventPtr event)
{
  FormPtr form ;

  switch (event->eType) 
    {
    case frmOpenEvent:
      form = FrmGetActiveForm () ;
      { ListPtr list ;
      ControlPtr trigger ;
      ControlPtr chkbox ;

      /* Sets defaults for horizontal game size */
      list = FrmGetObjectPtr (form, FrmGetObjectIndex (form, horizontalList)) ;
      trigger = FrmGetObjectPtr (form,
				 FrmGetObjectIndex (form, horizontalTrigger)) ;
      LstSetSelection (list, (Word)(game_width - 1)) ;
      CtlSetLabel (trigger,
		   LstGetSelectionText (list, (Word)(game_width - 1))) ;
      /* Sets defaults for vertical game size */
      list = FrmGetObjectPtr (form, FrmGetObjectIndex (form, verticalList)) ;
      trigger = FrmGetObjectPtr (form,
				 FrmGetObjectIndex (form, verticalTrigger)) ;
      LstSetSelection (list, (Word)(game_height - 1)) ;
      CtlSetLabel (trigger,
		   LstGetSelectionText (list, (Word)(game_height - 1))) ;
      /* Sets default for first player flag */
      chkbox = FrmGetObjectPtr (form,
				FrmGetObjectIndex (form, firstChkbox)) ;
      CtlSetValue (chkbox, (short) pilot_plays_first) ;
      }
      FrmDrawForm (form) ;
      return (TRUE) ;
      break ;


    case ctlSelectEvent:
      /* Buttons */
      switch (event->data.ctlEnter.controlID)
	{
	case okButton:
	  if ((remaining_cells > 0)
	      && (FrmCustomAlert (standardYesNoAlert,
				  "This will abort current game.",
				  "Continue ?", "") == 1)) {
	    /* A game is alive but user does't want to abort it */
	    FrmReturnToForm (0) ;
	  }
	  else
	    { ListPtr list ;
	    Word selection ;
	    ControlPtr chkbox ;

	    /* Get new game width */
	    form = FrmGetActiveForm () ;
	    list = FrmGetObjectPtr (form,
				    FrmGetObjectIndex (form, horizontalList)) ;
	    selection = (unsigned char) LstGetSelection (list) ;
	    if (selection != -1) game_width = (unsigned char) selection+1 ;
	    /* Get new game height */
	    list = FrmGetObjectPtr (form,
				    FrmGetObjectIndex (form, verticalList)) ;
	    selection = (unsigned char) LstGetSelection (list) ;
	    if (selection != -1) game_height = (unsigned char) selection+1 ;
	    /* Get new first player flg */
	    chkbox = FrmGetObjectPtr (form,
				      FrmGetObjectIndex (form, firstChkbox)) ;
	    pilot_plays_first = CtlGetValue (chkbox) ;
	    
	    /* Frees old data structure */
	    MemPtrFree (vertices) ;
	    MemPtrFree (edges) ;
	    MemPtrFree (cells) ;
	    /* Allocates new ones */
	    init_game_data () ;
	    /* Must return to parent form before displaying intro screen ! */
	    FrmReturnToForm (0) ;
	    DisplayIntro () ;
	    }
	  return (TRUE) ;
	  break ;

	case cancelButton:
	  FrmReturnToForm (0) ;
	  return (TRUE) ;
	  break ;
	}
      break ;
    }

  return (FALSE) ;
}
