/*  OpenChess.h -- PalmOS headers for GNU Chess2
 *
 *  OpenChess version 1.0, is a CHESS game for Palm Pilot, adapted 
 *  from GNU Chess 2, for Unix/DOS environments
 *  Copyright (C) 1986, 1987, 1988 Free Software Foundation, Inc.
 *  Copyright (C) 2002, Son Altesse.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// GNUChess structures
struct TimeControlRec
  {
    short moves[2];
    long clock[2];
  };
struct GameRec
  {
    unsigned short gmove;
    short score,depth,time,piece,color;
// ADDED for Pawn promotion undo bug in GNU Chess !
		short pawnpromote;
// END EDDED    
    long nodes;
  };
struct hashentry
  {
    unsigned long hashbd;
    unsigned short mv,flags;
    short score,depth;
  };
struct leaf
  {
    short f,t,score,reply;
    unsigned short flags;
  };
struct BookEntry
  {
    struct BookEntry *next;
    unsigned short *mv;
  };

// GNUChess defines
#define neutral 2
#define white 0
#define black 1
#define no_piece 0
#define pawn 1
#define knight 2
#define bishop 3
#define rook 4
#define queen 5
#define king 6
#define valueP 100
#define valueN 350
#define valueB 355
#define valueR 550
#define valueQ 1100
#define valueK 1200
#define ctlP 0x4000
#define ctlN 0x2800
#define ctlB 0x1800
#define ctlR 0x0400
#define ctlQ 0x0200
#define ctlK 0x0100
#define ctlBQ 0x1200
#define ctlRQ 0x0600
#define ctlNN 0x2000
#define pxx " PNBRQK"
#define qxx " pnbrqk"
#define rxx "12345678"
#define cxx "abcdefgh"
#define check 0x0001
#define capture 0x0002
#define draw 0x0004
#define promote 0x0008
#define cstlmask 0x0010
#define epmask 0x0020
#define exact 0x0040
#define pwnthrt 0x0080
#define truescore 0x0001
#define lowerbound 0x0002
#define upperbound 0x0004
#define maxdepth 30
#define true 1
#define false 0
#define absv(x) ((x) < 0 ? -(x) : (x))
#define taxicab(a,b) (abs(column[a]-column[b]) + abs(row[a]-row[b]))

// GNUchess Globals
extern short mate,post,opponent,computer,Sdepth,Awindow,Bwindow,dither;
extern short GameCnt,Game50,epsquare,lpost,rcptr,contempt;
extern short castld[2],kingmoved[2],mtl[2],pmtl[2],emtl[2],hung[2];
extern short TCflag,TCmoves,TCminutes,OperatorTime;
extern struct TimeControlRec TimeControl;
extern short TrPnt[maxdepth],board[64],color[64];
extern struct GameRec GameList[240];
extern short quit,reverse,bothsides,hashflag,InChk,player,force,easy,beep;
extern short row[64],column[64],locn[8][8],Pindex[64],svalue[64];
extern struct hashentry /*huge*/ *ttable,*ptbl;
/* unsigned char history[8192]; */
/* Modified for PalmOS */
extern unsigned char *history;
extern long ResponseTime,ExtraTime,Level,et,et0,time0,cputimer,ft;
extern short otherside[3];
extern long NodeCnt,evrate,ETnodes,EvalNodes,HashCnt;
extern short wking,bking,FROMsquare,TOsquare,timeout,Zscore,zwndw,xwndw,slk;
extern unsigned short PV,hint,Swag0,Swag1,Swag2,Swag3,Swag4;
extern char mvstr1[5],mvstr2[5],mvstr3[6];
extern struct leaf Tree[1500],*root;
extern struct BookEntry *Book;
extern short PieceList[2][16],PieceCnt[2],atak[2][64],PawnCnt[2][8];


// GNUchess prototypes
#define SECTION_ONE  __attribute__ ((section ("section1")))
//#define SECTION_TWO  __attribute__ ((section ("section2")))

extern void InitializeStats(void); 
extern void OpenChessMain(void) SECTION_ONE;
extern void NewGame(void) SECTION_ONE;
extern int VerifyMove(char s[], short iop, unsigned short *mv); //SECTION_ONE;
extern void algbr(short f,short t,short flag); //SECTION_ONE;
extern int distance(short a,short b);
extern int SelectMove(short side,short iop); //SECTION_ONE;
extern int SqAtakd(short sq,short side); 
extern int castle(short side,short kf,short kt,short iop); // SECTION_ONE; 

