/* 
 *  os_35_extra.h
 *  definitions missing from OnBoardHeader.h,
 *  assembled from Palm SDK 3.5 header files.
 *
 *  Last Updated: 2004/10/27
 *
 *	Copyright (c) 1994-1999, Palm Computing Inc., All Rights Reserved 
 * 
*/

#define menuOpenEvent 0x0801
//#define menuCloseEvent 0x0802

typedef Boolean FormCheckResponseFuncType (Int16 button, Char * attempt); 
typedef FormCheckResponseFuncType *FormCheckResponseFuncPtr;

void FldSetMaxChars (FieldType *fldP, UInt16 maxChars) SYS_TRAP(sysTrapFldSetMaxChars); 
void FrmSetMenu (FormType *formP, UInt16 menuRscID) SYS_TRAP(sysTrapFrmSetMenu); 
void FrmCopyTitle (FormType *formP, const Char *newTitle) SYS_TRAP(sysTrapFrmCopyTitle); 
extern const Char *FrmGetLabel (const FormType *formP, UInt16 labelID) SYS_TRAP(sysTrapFrmGetLabel); 
UInt16 FrmCustomResponseAlert (UInt16 alertId, const Char *s1, const Char *s2, const Char *s3,
    Char *entryStringBuf, Int16 entryStringBufLength,
    FormCheckResponseFuncPtr callback)
    SYS_TRAP(sysTrapFrmCustomResponseAlert);

void CtlSetGraphics(ControlType *controlP, DmResID newBitmapID, DmResID newSelectedBitmapID) SYS_TRAP(sysTrapCtlSetGraphics); 
void CtlSetLabel(ControlType *controlP, const Char *newLabel) SYS_TRAP(sysTrapCtlSetLabel); 
const Char *CtlGetLabel (const ControlType *controlP) SYS_TRAP(sysTrapCtlGetLabel); 
void CtlHitControl (const ControlType *controlP) SYS_TRAP(sysTrapCtlHitControl);

void LstMakeItemVisible (ListType *listP, Int16 itemNum)
    SYS_TRAP(sysTrapLstMakeItemVisible); 
void LstDrawList (ListType *listP) SYS_TRAP(sysTrapLstDrawList); 
Int16 LstPopupList (ListType *listP) SYS_TRAP(sysTrapLstPopupList); 

UInt16 SysTicksPerSecond(void) SYS_TRAP(sysTrapSysTicksPerSecond); 

void RctSetRectangle (RectangleType *rP,
    Coord left, Coord top, Coord width, Coord height)
    SYS_TRAP(sysTrapRctSetRectangle); 

void WinDrawChar (WChar theChar, Coord x, Coord y)
    SYS_TRAP(sysTrapWinDrawChar);
void WinDrawTruncChars(const Char *chars, Int16 len, Coord x, Coord y, Coord maxWidth)
    SYS_TRAP(sysTrapWinDrawTruncChars); 

void FntCharsInWidth (const Char *string, Int16 *stringWidthP, Int16 *stringLengthP, Boolean *fitWithinWidth)
    SYS_TRAP(sysTrapFntCharsInWidth); 

typedef TableType *TablePtr;
enum tableItemStyles {
  checkboxTableItem,
  customTableItem,
  dateTableItem,
  labelTableItem,
  numericTableItem,
  popupTriggerTableItem,
  textTableItem,
  textWithNoteTableItem,
  timeTableItem,
  narrowTextTableItem
};
typedef enum tableItemStyles TableItemStyleType;
typedef Err TableLoadDataFuncType 
    (void *tableP, Int16 row, Int16 column, Boolean editable, 
    MemHandle * dataH, Int16 *dataOffset, Int16 *dataSize, FieldPtr fld); 
typedef TableLoadDataFuncType *TableLoadDataFuncPtr; 
typedef Boolean TableSaveDataFuncType
    (void *tableP, Int16 row, Int16 column); 
typedef TableSaveDataFuncType *TableSaveDataFuncPtr;

void TblSetItemStyle (TableType *tableP, Int16 row, Int16 column, TableItemStyleType type)
    SYS_TRAP(sysTrapTblSetItemStyle) ; 
void TblSetItemInt (TableType *tableP, Int16 row, Int16 column, Int16 value)
    SYS_TRAP(sysTrapTblSetItemInt); 
void TblSetColumnUsable (TableType *tableP, Int16 column, Boolean usable)
    SYS_TRAP(sysTrapTblSetColumnUsable);
void TblSetRowUsable (TableType *tableP, Int16 row, Boolean usable)
    SYS_TRAP(sysTrapTblSetRowUsable);
Int16 TblGetNumberOfRows (TableType *tableP)
    SYS_TRAP(sysTrapTblGetNumberOfRows);
void TblSetColumnWidth (TableType *tableP, Int16 column, Coord width)
    SYS_TRAP(sysTrapTblSetColumnWidth);
void TblSetLoadDataProcedure (TableType *tableP, Int16 column,
    TableLoadDataFuncPtr loadDataCallback)
    SYS_TRAP(sysTrapTblSetLoadDataProcedure); 
void TblSetSaveDataProcedure (TableType *tableP, Int16 column,
    TableSaveDataFuncPtr saveDataCallback)
    SYS_TRAP(sysTrapTblSetSaveDataProcedure); 
void TblSetRowSelectable (TableType *tableP, Int16 row, Boolean selectable)
    SYS_TRAP(sysTrapTblSetRowSelectable); 
void TblMarkRowInvalid (TableType *tableP, Int16 row)
    SYS_TRAP(sysTrapTblMarkRowInvalid); 
void TblRedrawTable (TableType *tableP)
    SYS_TRAP(sysTrapTblRedrawTable); 
 
//void TblSetItemFont (TableType *tableP, Int16 row, Int16 column, FontID fontID)
//    SYS_TRAP(sysTrapTblSetItemFont); 

//end

