/* OligoCalc V 1.04
 *
 * This is my first attempt to write a program  
 * for PalmPilot
 * I will add more features to it, if you have ideas, please let me know
 * 
 * Thanks to all the wonderful people who wrote GCC SDK for Palm Pilot,
 *
 * to Andrew Howletts for his GCC tutorial,
 * 
 * and to Serge Smirnov for a lot of good advice.
 *
 * Dmitry Mozzherin
 * dimus_m@hotmail.com
 * May-June 1998
 */

#pragma pack(2)
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#include "oligo.h"

#define OligoAppType   		'Dims'
#define OligoDBType     	'Data'
#define OligoDBName   		"OligoCalcDB"
#define NoRecordsSelected  -1

/***** DEFINE EXTINCTION COEFFICIENTS BELOW ******

 EXT_A, EXT_C, EXT_G, EXT_T are
 (molar extinction coefficient)/100 of AMP, CMP, GMP and TMP
 correspondently.
 You can change them to your numbers.

! IMPORTANT the molar extinction coefficients must be divided !
! by 100 and they must be integers                            !

 ************************************************/


//Molar ext. coeff. divided by 100:

#define EXT_A         153
#define EXT_C          74
#define EXT_G         118
#define EXT_T          93



static DmOpenRef   	OligoCalcDB;
static Word          CurrentRecord;


static int StartApplication(void);
static void EventLoop(void);
static void StopApplication(void);
static void GetRecords(void);
static void SetoligAttr(void);
static Boolean oligo(EventPtr event);
static void Calculate(void);
static void DrawBase(Char DrBase);

VoidHand        OligoH;
CharPtr         OligoP;
Word            ClbLength;


FieldPtr        fieldptr_oligo;
FieldPtr        fieldptr_ext;
FieldPtr        fieldptr_length;
FieldPtr        fieldptr_molweight;
FieldPtr        fieldptr_tmelt;
FieldPtr        fieldptr_odnmol;
FieldPtr        fieldptr_odug;
FieldPtr        fieldptr_cg;

char             ExportString[250];
char             len[4];
char             olig[101];
char             Ext[9];
char             MolW[10];
char             Tm[10];
char             Tm50[10];
char             ODNml[10];
char             ODUg[10];
char             CGpr[8];

int olint=0;
int DoSpace=0;
int CodonSize=0;
int BaseCount=0;

char Ade='A';
char Thy='T';
char Gua='G';
char Cyt='C';





/* the PilotMain function */


DWord  PilotMain (Word cmd, Ptr cmdPBP, Word launchFlags)
{
  int error;

  if (cmd == sysAppLaunchCmdNormalLaunch)
 {


	 error = StartApplication();	// Application start code
	 if (error) return error;

	 EventLoop();	// Event loop

	 StopApplication ();	// Application stop code
  }
  return 0;
}





/*Start Application function*/

static int StartApplication(void)
{
	Word		error;
	UInt		cardNo;
	LocalID	dbID;
	UInt		dbAttrs;
	UInt 		mode;
	UInt     index=0;
	VoidHand RecHandle;
	Ptr      RecPointer;
	char     nullstring=0;

	mode = dmModeReadWrite;

	//An attempt to open the database of OligoCalc

	OligoCalcDB = DmOpenDatabaseByTypeCreator(OligoDBType, OligoAppType, mode);
	if (! OligoCalcDB)
		{
		//If the database doesn't exist, create it now.

		error = DmCreateDatabase(0, OligoDBName, OligoAppType, OligoDBType, false);

		ErrFatalDisplayIf(error, "Could not create new database.");

		OligoCalcDB = DmOpenDatabaseByTypeCreator(OligoDBType, OligoAppType, mode);

		error = DmOpenDatabaseInfo(OligoCalcDB, &dbID, NULL, NULL, &cardNo, NULL);

		ErrFatalDisplayIf(error, "Could not get database info.");

		error = DmDatabaseInfo(0, dbID, NULL, &dbAttrs, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

		ErrFatalDisplayIf(error, "Could not get database info.");

		error = DmSetDatabaseInfo(0, dbID, NULL, &dbAttrs, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

		ErrFatalDisplayIf(error, "Could not set database info.");
		}
	CurrentRecord = 0;

	GetRecords();

	CurrentRecord=NoRecordsSelected;

	FrmGotoForm(formID_oligo);

}






/* Event Loop function */


static void EventLoop(void)
{
  short err;
  int formID;
  FormPtr form;
  EventType event;

  do
  {

	 EvtGetEvent(&event, 200);

	 if (SysHandleEvent(&event)) continue;
	 if (MenuHandleEvent((void *)0, &event, &err)) continue;

	  if (event.eType == frmLoadEvent)

	 {
		formID = event.data.frmLoad.formID;
		form = FrmInitForm(formID);
		FrmSetActiveForm(form);
		switch (formID)
		{
		case formID_oligo:
		  FrmSetEventHandler(form, (FormEventHandlerPtr) oligo);
		  break;
		}
	 }
	 FrmDispatchEvent(&event);
  }while(event.eType != appStopEvent);
}





/*Stop Application function*/


static void StopApplication(void)

{
	CharPtr	text;
	VoidPtr	textPtr;
	VoidHand	textHandle;
	UInt		index = 0;

// Writing the sequence to the database

	 text=FldGetTextPtr(fieldptr_oligo);
	 textHandle = DmNewRecord(OligoCalcDB, &index, StrLen(text) + 1);
	 textPtr = MemHandleLock(textHandle);
	 DmWrite(textPtr, 0, text, StrLen(text) + 1);
	 MemHandleUnlock(textHandle);
	 DmReleaseRecord(OligoCalcDB, index, true);

// Closing the database to clean the memory for other programms

	DmCloseDatabase(OligoCalcDB);

}

/***********************************************

Get Records function. It reads record 0 from
database, and get the last sequence

***********************************************/

static void GetRecords(void)
{
CharPtr RecText;
VoidHand RecHandle;

	if (CurrentRecord != NoRecordsSelected && DmNumRecords(OligoCalcDB) > 0)
		{
		RecHandle = DmGetRecord(OligoCalcDB, CurrentRecord);

		RecText = MemHandleLock(RecHandle);

		StrCopy(olig,RecText);

		MemHandleUnlock(RecHandle);

		DmReleaseRecord(OligoCalcDB, CurrentRecord, 0);

		DmRemoveRecord (OligoCalcDB,CurrentRecord);

		SetoligAttr();
		}
}

/****************************************************

Set olig Attributes function. It sets all necessary
variables for the oligonucleotide sequence

****************************************************/


static void SetoligAttr(void)
{
	for (olint=0;olig[olint]!=0;olint++)
	{
		if (olig[olint]==' ' && olint>0 && DoSpace==0)
			{
				DoSpace=1;
				CodonSize=olint;
			}
	}

	BaseCount=olint%(1+CodonSize);
		if (BaseCount==CodonSize && DoSpace==1)
			{
				olig[olint]=' ';
				BaseCount=0;
				olint++;
			}

 }

/***********************************************

					  oligo function

************************************************/




static Boolean oligo(EventPtr event)
{
  FormPtr   form;
  int       handled = 0;
  int       clr=0;
  CharPtr ParagraphString="\n";
  CharPtr ExtString="Ext=";
  CharPtr ExtUnitString="  1/(M cm)";
  CharPtr MWString="MW=";
  CharPtr MWUnitString=" Da";
  CharPtr LenString="Len=";
  CharPtr TmString="1M salt Tm=";
  CharPtr Tm50String="50mM salt Tm=";
  CharPtr GCString="GC%=";
  CharPtr NmolString="1 O.D.=";
  CharPtr NmolUnitString=" nmol";
  CharPtr MkgUnitString=" \265g";
  switch (event->eType) 
  {
  case frmOpenEvent:
    form = FrmGetActiveForm();
	 fieldptr_oligo = FrmGetObjectPtr(form, FrmGetObjectIndex(form, fieldID_oligo));
	 fieldptr_ext = FrmGetObjectPtr(form, FrmGetObjectIndex(form, fieldID_ext));
	 fieldptr_length=FrmGetObjectPtr(form,FrmGetObjectIndex(form, fieldID_length));
	 fieldptr_molweight=FrmGetObjectPtr(form,FrmGetObjectIndex(form,fieldID_molweight));
	 fieldptr_tmelt=FrmGetObjectPtr(form,FrmGetObjectIndex(form,fieldID_tmelt));
	 fieldptr_odnmol=FrmGetObjectPtr(form,FrmGetObjectIndex(form,fieldID_odnmol));
	 fieldptr_odug=FrmGetObjectPtr(form,FrmGetObjectIndex(form,fieldID_odug));
	 fieldptr_cg=FrmGetObjectPtr(form,FrmGetObjectIndex(form,fieldID_cg));

	 FldSetTextPtr(fieldptr_oligo, olig);
	 FldRecalculateField(fieldptr_oligo, true);
	 FrmDrawForm(form);
	 handled = 1;
	 break;

 case ctlSelectEvent:
	 if (event->data.ctlEnter.controlID== buttonID_ade)//Ade button was tapped
	 {
		{
		DrawBase(Ade);
      handled = 1;
      }
    break;
    }
   else if (event->data.ctlEnter.controlID== buttonID_thy)//Thy button was tapped
     {
       {
      DrawBase(Thy);
      handled = 1;
      }
    break;
    }
   
   else if (event->data.ctlEnter.controlID== buttonID_cyt)//Cyt button was tapped
     {
       {
      DrawBase(Cyt);
		handled = 1;
      }
    break;
    }
   else if (event->data.ctlEnter.controlID== buttonID_gua)//Gua button was tapped
     {
       {
     DrawBase(Gua);
      handled = 1;
      }
    break;
	 }
   
else if (event->data.ctlEnter.controlID== buttonID_backspace)//Bakspace  button was tapped
      {
	

      if (olint)
	{
	  if(DoSpace>0)
	    {
	      if(BaseCount>0)BaseCount--;
			else
	      {
	      olint--;
	      olig[olint]=0;
              BaseCount=CodonSize-1;
	      }
	    }
	    
      olint--;
      olig[olint]=0;
        FldSetTextPtr(fieldptr_oligo,olig);
	FldRecalculateField(fieldptr_oligo,true);
	FrmDrawForm(FrmGetActiveForm());
	        
	handled = 1;

        }
      break;
	}

else if (event->data.ctlEnter.controlID== buttonID_space)//Space button was tapped
     {
		if (DoSpace==0)
       {
       olig[olint]=' ';
       if (olint>0 && DoSpace==0) 
	 {
	   DoSpace=1;
	   CodonSize=olint;
	 }
       olint++;
      FldSetTextPtr(fieldptr_oligo, olig);
      FldRecalculateField(fieldptr_oligo, true);     
      FrmDrawForm(FrmGetActiveForm());
      handled = 1;
      }
    break;
    }


else if (event->data.ctlEnter.controlID== buttonID_clear)//Clr button was tapped
      {
	{
	for (clr=0; clr < 100; clr++) olig[clr]=0;  
	for (clr=0;clr<4;clr++)len[clr]=0;
	for(clr=0;clr<9;clr++)Ext[clr]=0;
	for(clr=0;clr<10;clr++) MolW[clr]=Tm[clr]=ODNml[clr]=ODUg[clr]=0;
        for(clr=0;clr<8;clr++) CGpr[clr]=0;
	olint=0;
	DoSpace=0;
	BaseCount=0;
	CodonSize=0;
        
	FldSetTextPtr(fieldptr_cg, CGpr);
	FldRecalculateField(fieldptr_cg,true);

	FldSetTextPtr(fieldptr_odnmol, ODNml);
	FldRecalculateField(fieldptr_odnmol,true);
	
	FldSetTextPtr(fieldptr_odug, ODUg);
	FldRecalculateField(fieldptr_odug,true);

	FldSetTextPtr(fieldptr_tmelt, Tm);
	FldRecalculateField(fieldptr_tmelt, true);

	FldSetTextPtr(fieldptr_length, len);
	FldRecalculateField(fieldptr_length, true);

	FldSetTextPtr(fieldptr_molweight, MolW);
	FldRecalculateField(fieldptr_molweight, true);

	FldSetTextPtr(fieldptr_ext, Ext);
	FldRecalculateField(fieldptr_ext, true);

	FldSetTextPtr(fieldptr_oligo,olig);
	FldRecalculateField(fieldptr_oligo,true);

	FrmDrawForm(FrmGetActiveForm());
	handled=1;
	}
	  break;
		}
	else if  (event->data.ctlEnter.controlID== buttonID_calc)
	  {
		 {
		Calculate();
		handled = 1;
		 }
	 break;
	  }
	  case menuEvent:
	 switch (event->data.menu.itemID)
	 {
	 case menuitemID_calc:
		Calculate();
		break;
	 case menuitemID_export:

		StrCat(ExportString,olig);
		StrCat(ExportString,ParagraphString);
		StrCat(ExportString,ExtString);
		StrCat(ExportString,Ext);
		StrCat(ExportString,ExtUnitString);
		StrCat(ExportString,ParagraphString);
		StrCat(ExportString,MWString);
		StrCat(ExportString,MolW);
		StrCat(ExportString,MWUnitString);
		StrCat(ExportString,ParagraphString);
		StrCat(ExportString,LenString);
		StrCat(ExportString,len);
		StrCat(ExportString,ParagraphString);
		StrCat(ExportString,TmString);
		StrCat(ExportString,Tm);
		StrCat(ExportString,ParagraphString);
		StrCat(ExportString,Tm50String);
		StrCat(ExportString,Tm50);
		StrCat(ExportString,ParagraphString);
		StrCat(ExportString,GCString);
		StrCat(ExportString,CGpr);
		StrCat(ExportString,ParagraphString);
		StrCat(ExportString,NmolString);
		StrCat(ExportString,ODNml);
		StrCat(ExportString,NmolUnitString);
		StrCat(ExportString,ParagraphString);
		StrCat(ExportString,NmolString);
		StrCat(ExportString,ODUg);
		StrCat(ExportString,MkgUnitString);
		StrCat(ExportString,ParagraphString);
		ClipboardAddItem(clipboardText,ExportString,StrLen(ExportString));
		for (clr=0;clr<250;clr++) ExportString[clr]=0;
		break;
	 case menuitemID_about:
		FrmAlert(alertID_about);
		break;
	 case menuitemID_copy:
		FldCopy(fieldptr_oligo);
		FldCopy(fieldptr_ext);
		FldCopy(fieldptr_molweight);
		FldCopy(fieldptr_length);
		FldCopy(fieldptr_tmelt);
		FldCopy(fieldptr_odnmol);
		FldCopy(fieldptr_odug);
		FldCopy(fieldptr_cg);

// user has to select (highlight) the text to copy
		break;
	 case menuitemID_paste:

		OligoH=ClipboardGetItem(clipboardText,&ClbLength);

		if(ClbLength==0){handled=1;break;}
		if(ClbLength>100)
	{
	  FrmAlert(alertID_errorsize);
	  handled=1;
	  break;
	}


		OligoP=MemHandleLock(OligoH);

		for (olint=0;olint<100;olint++)olig[olint]=0;
		for (olint=0;olint<ClbLength;olint++)
	{
	  olig[olint]=*(OligoP+olint);
	  if (olig[olint]==' ' && olint>0 && DoSpace==0)
		 {
			DoSpace=1;
			CodonSize=olint;
		 }

	}
		BaseCount=ClbLength%(1+CodonSize);
			  if (BaseCount==CodonSize && DoSpace==1)
			{
		olig[olint]=' ';
		BaseCount=0;
		olint++;
			}

		FldSetTextPtr(fieldptr_oligo,olig);
		FldRecalculateField(fieldptr_oligo,true);


		MemHandleUnlock(OligoH);

	 }

	 handled = 1;
	 break;

  case nilEvent:
	 handled = 1;
	 break;
  }
  return handled;
}



/*****************************************************************
 *
 *Draw Base function
 *
 ****************************************************************/

static void DrawBase(Char DrBase)

 {

if (olint<100)
  {
		olig[olint]=DrBase;
		olint++;
		  if(DoSpace)
	  {
		BaseCount++;
		  if (BaseCount==CodonSize)
	  {olig[olint]=' ';
	  olint++;
	  BaseCount=0;
	  }
	  }
		FldSetTextPtr(fieldptr_oligo, olig);
		FldRecalculateField(fieldptr_oligo, true);
		FrmDrawForm(FrmGetActiveForm());
  }
 }


/******************************************************
 *
 *Calculate function
 *
 *****************************************************/


static void Calculate(void)
{
  char  textchar;
  int  textpos;
  int  textlength;
  CharPtr  textpointer;

Long Adenines=0;
Long Thymines=0;
Long Guanines=0;
Long Cytosines=0;
Long Spaces=0;
Long Extinction;
ULong MolWeight;
Long Length;
Long TMelt, TMelt50,  CG, CGpercent, Nvalue;
Long ODNmol, ODUgram;

  textpointer = FldGetTextPtr(fieldptr_oligo);
  textlength = FldGetTextLength(fieldptr_oligo);
  if (textlength)
  {
   
 for (textpos = 0; textpos < textlength; textpos ++)
{
textchar=textpointer[textpos];
	 if (textchar=='A' || textchar=='a')      
	   {
            Adenines=Adenines++; 
	   } 
       
	 else if (textchar=='T' || textchar=='t')
	   {
	     Thymines=Thymines++;
	   }

	else if (textchar=='C' || textchar=='c')
	  {
	    Cytosines=Cytosines++;
	  }
   
	else if (textchar=='G' || textchar=='g')
	  {
	    Guanines=Guanines++;
	  }

        else if (textchar==' ')
	  {
	    Spaces=Spaces++;
	  }
        else          
          {
             FrmAlert (alertID_erroroligo);
             break;
          }
	    
}


// Calculation of extinction coefficient 
 
Extinction=Adenines*EXT_A+Thymines*EXT_T+Cytosines*EXT_C+Guanines*EXT_G;
StrIToA(Ext,Extinction);

for(textpos=0;Ext[textpos]!=0;textpos++);
Ext[textpos]='0';
textpos++;
Ext[textpos]='0';
textpos++;
Ext[textpos]=0;




/*Calculation of the length of the oligo*/

Length=Adenines+Thymines+Cytosines+Guanines;
StrIToA(len,Length);

    FldSetTextPtr(fieldptr_length, len);
    FldRecalculateField(fieldptr_length, true);
    

/*Calculation of Molecular Weight
MolWeight=(((Adenines*313.2)+(Cytosines*289.2)+(Guanines*329.2)+(Thymines*304.2))-62)+((textlength-1)*17);*/
 
MolWeight=Adenines*3132+Thymines*3042+Cytosines*2892+Guanines*3292-620;
textlength=Length;
textlength=textlength*10-10;
textlength=textlength*17;
MolWeight=MolWeight+textlength;
StrIToA(MolW,MolWeight);

/* Next step is "dividing" Molweight by 10 */

for(textpos=0;MolW[textpos]!=0;textpos++);
textlength=textpos-1;
MolW[textpos]=MolW[textlength];
MolW[textlength]='.';


/*
 * Calculation of melting temperature by formula:
 * tm=81.5+0.41(%GC)-675/N-%mismatches
 * in this version without mismatches yet
 */
CG=Guanines+Cytosines;
CGpercent=41000/Length*CG;
Nvalue=675000/Length;
TMelt=81500+CGpercent-Nvalue;
TMelt50=TMelt-21600;
if (TMelt<10000)
  {
Tm[0]='<';
Tm[1]='1';
Tm[2]='0';
Tm[3]='\260';
Tm[4]=0;
  }
else if (TMelt>=100000)
  {
  Tm[0]='>';
  Tm[1]='1';
  Tm[2]='0';
  Tm[3]='0';
  Tm[4]='\260';
  Tm[5]=0;
  }
else
  {
StrIToA(Tm,TMelt);
Tm[5]=0;
Tm[4]='\260';
Tm[3]=Tm[2];
Tm[2]='.';
  }

if (TMelt50<10000)
  {
Tm50[0]='<';
Tm50[1]='1';
Tm50[2]='0';
Tm50[3]='\260';
Tm50[4]=0;
  }
else if (TMelt50>=100000)
  {
  Tm50[0]='>';
  Tm50[1]='1';
  Tm50[2]='0';
  Tm50[3]='0';
  Tm50[4]='\260';
  Tm50[5]=0;
  }
else
  {
StrIToA(Tm50,TMelt50);
Tm50[5]=0;
Tm50[4]='\260';
Tm50[3]=Tm50[2];
Tm50[2]='.';
  }



/* Calculation of 1 O.D.= x nmol  */

ODNmol=1000000/Extinction;
     for(textpos=0;textpos<10;textpos++)
     ODNml[textpos]=0;
StrIToA(ODNml, ODNmol);

//"dividing" nmol by 100
for(textpos=0;ODNml[textpos]!=0;textpos++);
textlength=textpos-1;
ODNml[textpos]=ODNml[textlength];
textlength=textpos-2;
ODNml[textpos-1]=ODNml[textlength];
ODNml[textlength]='.';

/*Calculation of 1 O.D.=x ug */
ODUgram=MolWeight*10/Extinction;
StrIToA(ODUg,ODUgram);

for(textpos=0;ODUg[textpos]!=0;textpos++);
textlength=textpos-1;
ODUg[textpos]=ODUg[textlength];
ODUg[textlength]='.';

/* Calculation of CG%*/

if (CG)
  {
CGpercent=CG*10000;
CGpercent=CGpercent/Length;
StrIToA(CGpr,CGpercent);
for(textpos=0;CGpr[textpos]!=0;textpos++);
CGpr[textpos+1]=CGpr[textpos];
CGpr[textpos]=CGpr[textpos-1];
CGpr[textpos-1]=CGpr[textpos-2];
CGpr[textpos-2]='.';
  }
else 
  {
CGpr[0]='0';
CGpr[1]=0;
  }


    
    FldSetTextPtr (fieldptr_cg, CGpr);
    FldRecalculateField(fieldptr_cg,true);
    

    FldSetTextPtr (fieldptr_odug, ODUg);
    FldRecalculateField(fieldptr_odug,true);
    
    FldSetTextPtr(fieldptr_odnmol,ODNml);
    FldRecalculateField(fieldptr_odnmol,true);    

    FldSetTextPtr(fieldptr_tmelt, Tm);
    FldRecalculateField(fieldptr_tmelt, true);


    FldSetTextPtr(fieldptr_molweight, MolW);
    FldRecalculateField(fieldptr_molweight, true);
    
    FldSetTextPtr(fieldptr_ext, Ext);
    FldRecalculateField(fieldptr_ext, true);
    FrmDrawForm(FrmGetActiveForm());
  }
  else
  {
    FrmAlert(alertID_erroroligo);
  }
}





