#define datebookPrefsVersionNum				4
#define datebookPrefID							0x00

// Struct for the datebook prefs
typedef enum alarmTypes {aauMinutes, aauHours, aauDays} AlarmUnitType;

typedef struct {
	Int8					advance;			// Alarm advance (-1 = no alarm)
  AlarmUnitType		advanceUnit;	// minutes, hours, days
} AlarmInfoType;

typedef struct {
	UInt16				dayStartHour;
	UInt16				dayEndHour;
	AlarmInfoType		alarmPreset;
	FontID				v20NoteFont;		// Changed for 2.0 compatibility (BGT)
	Boolean				saveBackup;
	Boolean				showTimeBars;
	Boolean				compressDayView;
	Boolean				showTimedAppts;
	Boolean				showUntimedAppts;
	Boolean				showDailyRepeatingAppts;
	UInt8					reserved;
	
	// Version 3 preferences
	UInt16 				alarmSoundRepeatCount;
	UInt16 				alarmSoundRepeatInterval;
	UInt32				alarmSoundUniqueRecID;
	FontID				apptDescFont;
	FontID				noteFont;		// Changed for 2.0 compatibility (BGT)
	
	// Version 4 preferences
	UInt16					alarmSnooze;
} DatebookPreferenceType;