// Enigma's Game Editor
// Copyright (C) 2001 Brian Enigma <enigma@netninja.com>
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version. 
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details. 
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// $Id: quest.c,v 1.7 2001/06/08 08:53:05 enigma Exp $

static Boolean questHandleEvent(EventType *event);
static Boolean questPopulate();
static Boolean questPopulateInfo(int record);
static Boolean questSaveInfo();

Boolean questSeen = false;

static Boolean questHandleEvent(EventType *event)
{
    switch (event->eType)
    {
        case winEnterEvent:
            questPopulate();
            return true;
        case lstSelectEvent:
            questPopulateInfo(event->data.lstSelect.selection);
            return true;
        case ctlSelectEvent:
            // Cancel button
            if (event->data.ctlSelect.controlID == BtnQuestCancel)
            {
                // Jump to main form
                FrmGotoForm(FrmMain);
                return true;
            // OK button
            } else if (event->data.ctlSelect.controlID == BtnQuestOk) {
                // Save things
                questSaveInfo();
                // Jump to main form
                FrmGotoForm(FrmMain);
                return true;
            }
    }
    return false;
}

// Display error message if no save games
static void questErrorNoSaveGame()
{
    if (!questSeen)
    {
        questSeen = true;
        FrmCustomAlert(AltError,
            "Before editing, you must first save a Kyle's Quest game.","","");
    }
}


// Populate form data in the Quest form
static Boolean questPopulate()
{
    MemHandle text;
    MemHandle rec;
    LocalID dbId = 0;
    DmOpenRef db = 0;
    FormPtr form = FrmGetActiveForm();
    ListPtr listPtr = FrmGetObjectPtr(form, FrmGetObjectIndex(form, LstQuestGames));
    DmSearchStateType sState;
    short junk;
    int i = 0;
    char name[33];
    Err rc;
    UInt16 attr;
    int pos;
    char *test;

    clearList(1);
    rc = DmGetNextDatabaseByTypeCreator(true, &sState, QUEST_TYPE, 
            QUEST_CREATOR, false, &junk, &dbId);
    if ((rc == dmErrCantFind) || (dbId == 0))
    {
        questErrorNoSaveGame();
        return true;
    }
    do
    {
        listIds[i] = dbId;
        MemSet((void *)name, 33, 0);
        DmDatabaseInfo(0, dbId, name, &attr, NULL, NULL, NULL, NULL, 
            NULL, NULL, NULL, NULL, NULL);
        pos = StrLen(name);
        test = name;
        test += (pos - 4);
        if ( (StrCompare(test, " sv3")==0) || (StrCompare(test, " cnt")==0))
        {
            list[i] = MemPtrNew(33);
            StrCopy(list[i], name);
            i++;
        }
    } while ( (i<10) && (!DmGetNextDatabaseByTypeCreator(false, &sState, 
            QUEST_TYPE, QUEST_CREATOR, false, &junk, &dbId)) );
   
    LstSetListChoices(listPtr, list, i);
    LstDrawList(listPtr);
    if (i > 0)
    {
        LstSetSelection(listPtr, 0);
        questPopulateInfo(0);
    }
    return true;
}

static Boolean questPopulateInfo(int record)
{
    LocalID dbId = 0;
    
    dbId = listIds[record];
    loadFieldFromFile(TxtQuestHealth1,      TYPE_INT, dbId, 0, 0x08);
    loadFieldFromFile(TxtQuestHealth2,      TYPE_INT, dbId, 0, 0x0A);
    loadFieldFromFile(TxtQuestMoney,        TYPE_INT, dbId, 0, 0x18);
    loadFieldFromFile(TxtQuestStrength,     TYPE_INT, dbId, 0, 0x0E);
    loadFieldFromFile(TxtQuestAgility,      TYPE_INT, dbId, 0, 0x0C);
    loadFieldFromFile(TxtQuestIntelligence, TYPE_INT, dbId, 0, 0x10);
    return true;
}

static Boolean questSaveInfo()
{
    LocalID dbId = 0;
    FormPtr form = FrmGetActiveForm();
    ListPtr listPtr = FrmGetObjectPtr(form, FrmGetObjectIndex(form, LstQuestGames));
    int record = LstGetSelection(listPtr);
    
    dbId = listIds[record];
    if (dbId)
    {
        saveFieldToFile(TxtQuestHealth1,        TYPE_INT, dbId, 0, 0x08);
        saveFieldToFile(TxtQuestHealth2,        TYPE_INT, dbId, 0, 0x0A);
        saveFieldToFile(TxtQuestMoney,          TYPE_INT, dbId, 0, 0x18);
        saveFieldToFile(TxtQuestStrength,       TYPE_INT, dbId, 0, 0x0E);
        saveFieldToFile(TxtQuestAgility,        TYPE_INT, dbId, 0, 0x0C);
        saveFieldToFile(TxtQuestIntelligence,   TYPE_INT, dbId, 0, 0x10);
    }
    return true;
}
