// Enigma's Game Editor
// Copyright (C) 2001 Brian Enigma <enigma@netninja.com>
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version. 
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details. 
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// $Id: simcity.c,v 1.9 2001/06/08 08:53:05 enigma Exp $

static Boolean simHandleEvent(EventType *event);
static Boolean simPopulate();
static Boolean simPopulateMoney(int record);
static Boolean simSaveMoney();

Boolean simSeen = false;

static Boolean simHandleEvent(EventType *event)
{
    switch (event->eType)
    {
        case winEnterEvent:
            simPopulate();
            return true;
        case lstSelectEvent:
            simPopulateMoney(event->data.lstSelect.selection);
            return true;
        case ctlSelectEvent:
            // Cancel button
            if (event->data.ctlSelect.controlID == BtnSimCancel)
            {
                // Jump to main form
                FrmGotoForm(FrmMain);
                clearList(1);
                return true;
            // OK button
            } else if (event->data.ctlSelect.controlID == BtnSimOk) {
                // Save things
                simSaveMoney();
                // Jump to main form
                clearList(1);
                FrmGotoForm(FrmMain);
                return true;
            }
    }
    return false;
    
}

// Display error message if no save game
static void simErrorNoSaveGame()
{
    if (!simSeen)
    {
        simSeen = true;
        FrmCustomAlert(AltError,
            "Before editing, you must first save a SimCity game.","","");
    }
}

// Populate form data in the Sim form
static Boolean simPopulate()
{
    MemHandle text;
    MemHandle rec;
    MemPtr p;
    LocalID dbId = 0;
    DmOpenRef db = 0;
    FormPtr form = FrmGetActiveForm();
    ListPtr listPtr = FrmGetObjectPtr(form, FrmGetObjectIndex(form, LstSimGames));
    int max = 0;
    int i;
    UInt16 attr = 0;
    int found = 0;

    clearList(1);
    //SndPlaySystemSound(sndError);
    dbId = DmFindDatabase(0, "SimCity.Cities");
    if (dbId)
        db = DmOpenDatabase(0, dbId, dmModeReadWrite);
    if (db)
    {
        max = DmNumRecords(db);
        if (max > 10) max = 10;
        for (i=0; i<max; i++)
        {
            DmRecordInfo(db, i, &attr, NULL, NULL);
            if ((attr & dmRecAttrDelete) != dmRecAttrDelete)
            {
                rec = DmGetRecord(db, i);
                p = MemHandleLock(rec);
                list[i] = MemPtrNew(StrLen(p+2) + 1);
                StrCopy(list[i], p+2);
                //list[i] = 0;
                MemHandleUnlock(rec);
                DmReleaseRecord(db, i, false);
                found++;
            }
        }
        DmCloseDatabase(db);
    }
    if (found > 0)
    {
        LstSetListChoices(listPtr, list, found);
    }
    LstDrawList(listPtr);
    if (found > 0)
    {
        LstSetSelection(listPtr, 0);
        simPopulateMoney(0);
    }else{
        simErrorNoSaveGame();
    }
    return true;
}

static Boolean simPopulateMoney(int record)
{
    loadFieldFromFileByName(TxtSimMoney, TYPE_LONG, "SimCity.Cities", record, 0xC24);
    return true;
}

static Boolean simSaveMoney()
{
    FormPtr form = FrmGetActiveForm();
    ListPtr listPtr = FrmGetObjectPtr(form, FrmGetObjectIndex(form, LstSimGames));
    int record = LstGetSelection(listPtr);
    
    saveFieldToFileByName(TxtSimMoney, TYPE_LONG, "SimCity.Cities", record, 0xC24);
    return true;
}
